<?php
// Norādam, ka atgriežam JSON formāta atbildi
header('Content-Type: application/json');

// Datubāzes savienojuma parametri
$servername = "localhost";  // Datubāzes serveris
$username = "root";         // Datubāzes lietotājs
$password = "";             // Parole (tukša šajā gadījumā)
$dbname = "eraecho";        // Datubāzes nosaukums

// Izveido savienojumu ar MySQL datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Ja savienojums neizdodas, atgriežam kļūdas ziņojumu ar HTTP 500 statusu
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['message' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

// Pārbaudām, vai pieprasījums ir POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Iegūstam iekšējo JSON datus no pieprasījuma
    $jsonInput = file_get_contents('php://input');
    $requestData = json_decode($jsonInput, true);  // Atgriežam asociatīvo masīvu

    // Pārbaudām, vai JSON ir pareizs un vai nepieciešamās vērtības ir norādītas
    if (json_last_error() !== JSON_ERROR_NONE || empty($requestData['email']) || empty($requestData['password'])) {
        http_response_code(400);  // Ja dati ir nederīgi, atgriežam 400 kļūdas statusu
        echo json_encode(['message' => 'Invalid input. Email and password are required.']);
        exit;
    }

    // Iegūstam e-pasta un paroles datus no pieprasījuma
    $email = trim($requestData['email']);  // Noņemam liekos balstus no e-pasta
    $password = $requestData['password'];

    // Pārbaudām, vai e-pasta formāts ir derīgs
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);  // Ja e-pasts nav derīgs, atgriežam 400 kļūdas statusu
        echo json_encode(['message' => 'Invalid email format.']);
        exit;
    }

    // Sagatavojam SQL vaicājumu, lai meklētu lietotāju pēc e-pasta
    $query = "SELECT id, username, password FROM users WHERE email = ?";
    $stmt = $conn->prepare($query);  // Sagatavojam vaicājumu
    $stmt->bind_param("s", $email);  // Piesaistām parametrus (e-pasts)
    $stmt->execute();  // Izpildām vaicājumu
    $result = $stmt->get_result();  // Iegūstam rezultātus

    // Ja lietotājs ar šo e-pastu ir atrasts
    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();  // Ņemam pirmo (un vienīgo) rezultātu
        // Pārbaudām, vai ievadītā parole sakrīt ar to, kas ir datubāzē
        if (password_verify($password, $user['password'])) {
            http_response_code(200);  // Ja parole ir pareiza, atgriežam 200 statusu
            echo json_encode([
                'message' => 'Login successful.',
                'redirect' => '../homepage.html'  // Norādām URL, kur lietotājs tiek novirzīts pēc veiksmīgas pieteikšanās
            ]);
            exit;
        } else {
            http_response_code(401);  // Ja parole nav pareiza, atgriežam 401 kļūdas statusu
            echo json_encode(['message' => 'Invalid credentials.']);
            exit;
        }
    } else {
        http_response_code(401);  // Ja lietotājs nav atrasts, atgriežam 401 kļūdas statusu
        echo json_encode(['message' => 'Invalid credentials.']);
        exit;
    }

    // Slēdzam sagatavoto paziņojumu
    $stmt->close();
} else {
    http_response_code(405);  // Ja pieprasījums nav POST, atgriežam 405 kļūdas statusu
    echo json_encode(['message' => 'Method not allowed.']);
}

// Slēdzam datubāzes savienojumu
$conn->close();
?>
